﻿Imports System.Xml.Linq
Imports PBS.PartnerHub.ServiceModel
Imports ServiceStack.ServiceInterface
Imports ServiceStack.ServiceClient.Web
Imports ServiceStack.Common.ServiceClient.Web

Public Class ViaServiceModel

    Public Shared Sub ContactGet(username As String, password As String)
        'The ServiceStack JsonServiceClient is very Fiddler friendly.
        Dim client As New JsonServiceClient("https://partnerhub.pbsdealers.com/api")
        'All PartnerHub requests are authorized by a username and password provided by PBS.
        client.SetCredentials(username, password)
        'By default Servicestack clients will post prematurely without an authorization header, unless you set the AlwaysSendBasicAuthHeader flag to True. This can negatively impact extended debugging environments.
        client.AlwaysSendBasicAuthHeader = True

        Dim req As New ContactGet()
        'Every request (except session authentication) requires a Dealership Serial Number.
        req.SerialNumber = "9991.QA"
        'Criteria of the type of Contact, we are interested in.
        req.LastName = "SMITH"
        Dim resp = client.Post(Of ContactGetResponse)(req)

        Console.WriteLine("Get Via ServiceStack - {0} Contacts", resp.Contacts.Count)
        For Each l In resp.Contacts
            Console.WriteLine("Code:{0,-15} Name: {1} {2}", l.Code, l.FirstName, l.LastName)
        Next

        Console.WriteLine("All Done!")
        Console.ReadLine()
    End Sub

    Public Shared Sub VehicleChange(username As String, password As String)
        Dim client As New XmlServiceClient("https://partnerhub.pbsdealers.com/api") With {.UserName = username, .Password = password, .AlwaysSendBasicAuthHeader = True}

        Dim req As New VehicleChange
        req.VehicleInfo.SerialNumber = "9991.QA"

        'we try and find the correct vehicle we'd like to update based on 
        'matching one of the following references, in order of preference
        'vehicleId, then Vin, then StockNumber. you don't need to set all 
        'of these, just one will do.
        req.VehicleInfo.VehicleId = Guid.Parse("0389D180-A9E7-48D5-9AFB-92B6531E50CC")
        req.VehicleInfo.VIN = "XXXXXXXXXXXXXXXXX"
        req.VehicleInfo.StockNumber = "D6698"

        'next you want to set any fields you want updated
        req.VehicleInfo.Odometer = 55123
        req.VehicleInfo.Notes = "blah blah blah"
        req.VehicleInfo.Year = "2012"

        'the only gotcha to be aware of is that we do link a VehicleType
        'to the unit based on Make/Model/Trim. If you want to update the
        'corresponding vehicle type please pass all 3 of these fields.
        req.VehicleInfo.Make = "FORD"
        req.VehicleInfo.Model = "F150"
        req.VehicleInfo.Trim = "XLT"

        Dim resp = client.Post(Of Confirmation)(req)

        If Not resp.WasSuccessful Then
            Console.WriteLine("Whoa - that didn't work!")
            Console.WriteLine("Here's the error message...")
            Console.WriteLine(resp.Message)
        Else
            Console.WriteLine("Vehicle Change Comple!")
            Console.WriteLine("Here's the notes ...")
            Console.WriteLine(resp.Message)
            Console.WriteLine("Here's the Vehicle Id if you need it ...")
            Console.WriteLine(resp.ReferenceId)
        End If

        Console.WriteLine("All Done!")
        Console.ReadLine()
    End Sub

    Public Shared Sub AppointmentChange(username As String, password As String)
        Dim client As New ServiceStack.ServiceClient.Web.JsonServiceClient("http://partnerhub.pbsdealers.com")
        client.SetCredentials(username, password)
        client.AlwaysSendBasicAuthHeader = True

        Dim c As New ContactChange With {.IsAsynchronous = False}
        c.ContactInfo.SerialNumber = "9991.QA"
        c.ContactInfo.LastName = "BOB"
        c.ContactInfo.FirstName = "ARISTO"
        c.ContactInfo.Code = "BOB2014"

        Dim cConf = client.Post(Of Confirmation)(c)
        If Not cConf.WasSuccessful Then Throw New ApplicationException("Unable to add Contact - " & cConf.Message)

        Dim v As New VehicleChange With {.IsAsynchronous = False}
        v.VehicleInfo.SerialNumber = "9991.QA"
        v.VehicleInfo.Year = "2010"
        v.VehicleInfo.Make = "FORD"
        v.VehicleInfo.Model = "F150"
        v.VehicleInfo.Trim = "SUPER DUTY"
        v.VehicleInfo.OwnerRef = c.ContactInfo.ContactId

        Dim vConf = client.Post(Of Confirmation)(v)
        If Not vConf.WasSuccessful Then Throw New ApplicationException("Unable to add Contact - " & vConf.Message)

        Dim r As New AppointmentChange With {.IsAsynchronous = False}
        r.AppointmentInfo.SerialNumber = "9991.QA"
        r.AppointmentInfo.ContactRef = Guid.Parse(cConf.ReferenceId)
        r.AppointmentInfo.VehicleRef = Guid.Parse(vConf.ReferenceId)
        r.AppointmentInfo.AppointmentTime = Date.Now
        r.AppointmentInfo.RequestLines.Add(New AppointmentRequest With {
            .RequestCode = "O",
            .RequestDescription = "Some Request Description",
            .AllowedHours = 1})

        'quick note on usage, if you don't know the op code of the operation you want to add, we typically use the 
        'op code "O" to say this is a custom operation, defined by the RequestDescription

        Dim aConf = client.Post(Of Confirmation)(r)
        If Not aConf.WasSuccessful Then Throw New ApplicationException("Unable to add Appointment - " & aConf.Message)
    End Sub

    Public Shared Sub PartsOrderChange(username As String, password As String)
        Dim client As New ServiceStack.ServiceClient.Web.JsonServiceClient("http://partnerhub.pbsdealers.com") With {.UserName = username, .Password = password, .AlwaysSendBasicAuthHeader = True}

        Dim c As New PartsOrderChange With {.IsAsynchronous = False}
        c.PartsOrderInfo.SerialNumber = "9991.QA"
        c.PartsOrderInfo.ReferenceNumber = Date.Now.ToShortDateString
        c.PartsOrderInfo.OrderDate = Date.Now
        c.PartsOrderInfo.OrderLines.Add(New PartsOrderLine With {.PartNumber = "ABC123", .Quantity = 1})
        c.PartsOrderInfo.OrderLines.Add(New PartsOrderLine With {.PartNumber = "DEF456", .Quantity = 2})
        c.PartsOrderInfo.OrderLines.Add(New PartsOrderLine With {.PartNumber = "GHI789", .Quantity = 3})

        Dim orderConf = client.Post(Of Confirmation)(c)
        If Not orderConf.WasSuccessful Then Throw New ApplicationException("Unable to add PartsOrder - " & orderConf.Message)
    End Sub
End Class
